<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddStatsToSchoolInfo extends Migration
{
    public function up()
    {
        $this->forge->addColumn('school_info', [
            'stat_guru_angka'  => ['type' => 'INT', 'null' => true],
            'stat_guru_label'  => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'stat_guru_desc'   => ['type' => 'TEXT', 'null' => true],

            'stat_siswa_angka' => ['type' => 'INT', 'null' => true],
            'stat_siswa_label' => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'stat_siswa_desc'  => ['type' => 'TEXT', 'null' => true],

            'stat_ekskul_angka'=> ['type' => 'INT', 'null' => true],
            'stat_ekskul_label'=> ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'stat_ekskul_desc' => ['type' => 'TEXT', 'null' => true],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('school_info', [
            'stat_guru_angka','stat_guru_label','stat_guru_desc',
            'stat_siswa_angka','stat_siswa_label','stat_siswa_desc',
            'stat_ekskul_angka','stat_ekskul_label','stat_ekskul_desc',
        ]);
    }
}
